﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;

public class SeekingPhase : GamePhase
{
    public float TimeRemaining { get; private set; }
    public bool CanGetHint { get; set; }
    public bool ShowingHint { get; private set; }

    private float _CooldownElapsedTime = 0.0f;
    private float _HintShowedTime = 0.0f;

    private List<TimerInterval> _TimerIntervals = new List<TimerInterval>();

    public override void OnStartCurrentPhase()
    {
        //Enable the seeker, setup the timer and show the hint UI
        GameController.Instance.SeekerPlayerObject.GetComponent<BasicMovement>().CanMove = true;
        GameController.Instance.SeekerPlayerObject.GetComponent<SpriteRenderer>().SetOpacity(1.0f);
        TimeRemaining = GameController.Instance.RoundTime;
        PauseMenu.CanPause = true;
        GameController.Instance.HintUI.SetActive(true);
        GameController.Instance.SetHintLegend(InputManager.Instance.InputState);

        _TimerIntervals = GameController.Instance.TimerIntervals.Select(interval => interval.Clone()).ToList();

        GameController.Instance.Timer.SetActive(true);
        GameController.Instance.Timer.GetComponent<Animator>().Play("TimerTick", 0, 0);
        GameController.Instance.Timer.GetComponent<Animator>().speed = 1000.0f / TimeRemaining;
        GameController.Instance.Timer.GetComponent<Animator>().enabled = true;
        GameController.Instance.IsTimerPaused = false;

        //Reset hint variables
        ShowingHint = false;
        CanGetHint = true;

        //Seeking, so follow the seeker and blend from spawn to the seeker player
        GameController.Instance.PlayerVirtualCamera.Follow = GameController.Instance.SeekerPlayerObject.transform;
        GameController.Instance.SpawnVirtualCamera.BlendTo(GameController.Instance.PlayerVirtualCamera);
    }

    public override void Update()
    {
        if (ShowingHint)
        {
            //Increment the showed and cooldown time if we're showing a hint
            _HintShowedTime += Time.deltaTime * 1000.0f;
            _CooldownElapsedTime += Time.deltaTime * 1000.0f;
        }

        if(_CooldownElapsedTime >= GameManager.Instance.HintCooldown)
        {
            //We're cooled down now so we can show a hint again
            CanGetHint = true;
        }

        if(_HintShowedTime >= GameManager.Instance.HintShowTime)
        {
            //We've shown the hint for long enough, hide it and reset the variables
            GameController.Instance.HintUI.FindChild("HintDisplay").SetActive(false);
            GameController.Instance.HintUI.FindChild("HintPanel").SetActive(true);
            GameController.Instance.SetHintLegend(InputManager.Instance.InputState);
            _HintShowedTime = 0.0f;
            ShowingHint = false;
        }

        if (!GameController.Instance.IsTimerPaused)
        {
            if (TimeRemaining > 0.0f)
            {
                //We still have time, so decrement by delta time and check if we need to play a tick sound
                TimeRemaining -= (Time.deltaTime * 1000.0f);
                CheckTimerTick();
            }

            else if (TimeRemaining <= 0.0f)
            {
                //Time up, pause the ticking and reveal the hider
                TimeRemaining = 0.0f;
                GameController.Instance.IsTimerPaused = true;
                GameController.Instance.RevealHider();
            }
        }

        if(Input.GetKeyUp("joystick button 2") || Input.GetKeyUp(KeyCode.Backspace))
        {
            if(CanGetHint)
            {
                //We've pressed the button and can show a hint, so let's display it and begin cooling down
                GameController.Instance.DisplayHint();
                _CooldownElapsedTime = 0.0f;
                CanGetHint = false;
                ShowingHint = true;
            }
        }
    }

    public override void OnEndCurrentPhase()
    {
        //Seeking is over, so reset both players, hide the hint UI and reset the hint variabless
        GameController.Instance.HiderPlayerObject.GetComponent<Animator>().Play("Idle", -1, 0.0f);
        GameController.Instance.SeekerPlayerObject.GetComponent<Animator>().Play("Idle", -1, 0.0f);
        GameController.Instance.ReadyScreen.SetActive(false);
        GameController.Instance.HintUI.FindChild("HintDisplay").SetActive(false);
        GameController.Instance.HintUI.FindChild("HintPanel").SetActive(true);
        GameController.Instance.SetHintLegend(InputManager.Instance.InputState);
        GameController.Instance.HintUI.SetActive(false);
        CanGetHint = true;
        ShowingHint = false;
        _CooldownElapsedTime = 0.0f;
        _HintShowedTime = 0.0f;
        Time.timeScale = 1.0f;
    }

    private void CheckTimerTick()
    {
        if (_TimerIntervals.Count > 0)
        {
            if (_TimerIntervals[0].IntervalValue >= TimeRemaining)
            {
                //We've now past the interval, play the tick
                _TimerIntervals[0].PlayTick();

                if (_TimerIntervals[0].GetType() == typeof(TimerIntervalValue))
                {
                    //If it's an value, just remove it
                    _TimerIntervals.RemoveAt(0);
                }

                else
                {
                    if (((TimerIntervalRange)_TimerIntervals[0]).RemainingValues <= 0)
                    {
                        //If it's a range, remove it only if the remaining values are 0
                        _TimerIntervals.RemoveAt(0);
                    }
                }
            }
        }
    }
}
